C----------------------------------------------------------------------
        logical function fttrnn(value)

C       test if a R*4 value has a IEEE Not-a-Number (NaN) value
C       A NaN has all the exponent bits=1, and the fractional part not=0.  
C       The exponent field occupies bits 23-30,  (least significant bit = 0)
C       The mantissa field occupies bits 0-22


C       written by Wm Pence, HEASARC/GSFC, May 1992

        integer value

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        integer*2 compid(2)
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

C       COMPID is used by FITSIO to determine at run time what type of
C       machine it is running on.  Two I*2 integers are equivalenced to
C       the R*4 value of 1.111111111.  The resulting value of the integers
C       is machine specific, depending on whether R*4 values are stored in
C       IEEE format or not, and whether the bytes are swapped or not.
C       COMPID(1) will have the following value on the following machines:
C        MACHINE              COMPID(1)
C          VAX                  16526
C          SUN                  16270
C          DecStation, IBM PC   14564
C          IBM mainframe        16657

        fttrnn=.false.
        if (compid(1) .eq. 16526)then
C           on the VAX we can assume that all NaNs will be set to all bits on
C           (which is equivalent to an integer with a value of -1) because
C           this is what the IEEE to VAX conversion MACRO program returns
            if (value .eq. -1)fttrnn=.true.
        else
C           the following test works on all other supported machines
C           the sign bit may be either 1 or 0 so have to test both possibilites
            if (value .gt. 2139095040 .or. (value .lt. 0 .and. 
     1          value .gt. -8388608))fttrnn=.true.
        end if
        end
