C--------------------------------------------------------------------------
        subroutine fttkyn(iunit,nkey,keynam,keyval,status)

C       test that the keyword number NKEY has name = KEYNAM
C       and has value = KEYVAL
C
C       iunit   i  Fortran I/O unit number
C       nkey    i  sequence number of the keyword to test
C       keynam  c  name that the keyword is supposed to have
C       keyval  c  value that the keyword is supposed to have
C       OUTPUT PARAMETERS:
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991
C
        integer iunit,nkey,status
        character*(*) keynam,keyval
        character kname*8,value*30,comm*48

C       read the name and value of the keyword
        call ftgkyn(iunit,nkey,kname,value,comm,status)
        if (status .gt. 0)go to 900

C       test if the keyword has the correct name
        if (kname .ne. keynam)then
                status=208
                go to 900
        end if

C       check that the keyword has the correct value
        if (value .ne. keyval)then
                status=209
                go to 900
        end if

900     continue
        end
