C--------------------------------------------------------------------------
        subroutine ftrhdu(iunit,xtend,status)

C       read the CHDU structure by reading the header keywords which define
C       the size and structure of the header and data units.

C       iunit   i  Fortran I/O unit number
C       OUTPUT PARAMETERS:
C       xtend   i  returned type of extension:   0 = the primary HDU
C                                                1 = an ASCII table
C                                                2 = a binary table
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991
        
        integer iunit,xtend,status
        character keynam*8,exttyp*10,comm*30

        if (status .gt. 0)return

C       read first keyword to determine the type of the CHDU
        call ftgkyn(iunit,1,keynam,exttyp,comm,status)
        if (status .gt. 0)then
C               unknown type of FITS record; can't read it
                status=252
                go to 900
        end if

        if (keynam .eq. 'SIMPLE')then
C               initialize the parameters describing the primay HDU
                call ftpini(iunit,status)
                xtend=0
        else if (keynam.eq.'XTENSION')then
                if (exttyp(2:9) .eq. 'TABLE   ')then
C                       initialize the parameters for the ASCII table extension
                        call ftaini(iunit,status)
                        xtend=1
                else if (exttyp(2:9) .eq. 'BINTABLE' .or. exttyp(2:9) 
     &          .eq. 'A3DTABLE' .or. exttyp(2:9) .eq. '3DTABLE')then
C                       initialize the parameters for the binary table extension
                        call ftbini(iunit,status)
                        xtend=2
                else if (exttyp(2:9) .eq. 'IMAGE   ' .or. exttyp(2:9) 
     &                   .eq. 'IUEIMAGE')then
C                       initialize the parameters describing the IMAGE extension
                        call ftpini(iunit,status)
                        xtend=0
                else
C                       unknown extension type
                        status=251
                        xtend=-1
                end if
        else
C               unknown record 
                status=252
                xtend=-1
        end if
900     continue
        end
