C--------------------------------------------------------------------------
        subroutine ftpscl(ounit,bscale,bzero,status)

C       Primary SCaLing factor definition
C       Define the scaling factor for the primary header data.
C       This must be the first HDU of the FITS file.
C
C       ounit   i  Fortran I/O unit number
C       bscale  d  scaling factor
C       bzero   d  scaling zero point
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ounit,status
        double precision bscale,bzero

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne,nf
        parameter (nb = 12)
        parameter (ne = 128)
        parameter (nf = 512)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------
        
        integer ibuff,i,ngroup

        if (status .gt. 0)return

        ibuff=bufnum(ounit)

        if (tfield(ibuff) .le. 0)then
C               error: data structure must be defined first
                status=303
        end if

C       the primary array is actually interpreted as a binary table.  There
C       are two columns for each group: the first column contains the 
C       group parameters, if any, and the second column contains the
C       primary array of data.  
        ngroup=tfield(ibuff)/2
        do 10 i=1,ngroup
                tscale(i*2,ibuff)=bscale
                tzero(i*2,ibuff)=bzero
10      continue
        end
