C--------------------------------------------------------------------------
        subroutine ftprec(ounit,record,status)

C       write a 80 character record to the FITS header
C
C       ounit   i  fortran output unit number
C       record  c  input 80 character header record
C       OUTPUT PARAMETERS:
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        character*(*) record
        character*80  rec
        integer ounit,status,ibuff

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
C       nb = number of file buffers = max. number of FITS file opened at once
C       nf = maximum number of fields allowed in a table
C       ne = maximum number of extensions allowed in a FITS file
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)

C       bufnum = stores which file buffer is used for this unit
C       bufpnt = pointer showing which unit is associated with the file buffer
C       reclen = the record length in bytes of the FITS file
C       recnum = the sequence number of the current FITS file record
C       bytnum = the sequence number of the current byte in RECNUM
C       wrmode = indicates whether the FITS file was opened with write access
C       modify = indicates whether the current record has been modified
C       chdu = sequence number of the Current Header-Data Unit (starting at 1)
C       maxhdu = the highest numbered HDU in the FITS file so far encountered
C       hdstrt = the zero-index byte number of the start of the extension
C       hdend = the zero-index byte number of the start of the END record
C       nxthdr = the zero-index byte no. of the current position in the CHU
C       dtstrt = the zero-index byte no. of the start of the current data unit
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C-------END OF COMMON BLOCK DEFINITIONS:------- -----------------------------

        if (status .gt. 0)return

C       get the number of the data buffer used for this unit
        ibuff=bufnum(ounit)

        if (dtstrt(ibuff) .gt. 0 
     &    .and.(dtstrt(ibuff)-hdend(ibuff)) .le. 80)then
C               not enough room in the header for another keyword

C               try getting more header space
                call ftiblk(ounit,status)
                if (status .gt. 0)then
                        go to 900
                end if
        end if
                
        rec=record

C       make sure keyword name is in upper case
        call ftupch(rec(1:8))

C       test that keyword name contains only legal characters
        call fttkey(rec(1:8),status)

C       test that the rest of the record contains only legal values
        call fttrec(rec(9:80),status)

C       position the I/O pointer to the end of the header
        call ftmbyt(ounit,hdend(ibuff),.true.,status)

C       append the 80 characters to the output buffer:
        call ftpcbf(ounit,1,80,rec,status)
        if (status .gt. 0)go to 900

C       increment the pointer to the last header record
        hdend(ibuff)=hdend(ibuff)+80

900     continue
        end
