C--------------------------------------------------------------------------
        subroutine ftpkys(ounit,keywrd,strval,comm,status)

C       write a character string value to a header record 
C
C       ounit   i  fortran output unit number
C       keywrd  c  keyword name    ( 8 characters, cols.  1- 8)
C       strval  c  keyword value 
C       comm    c  keyword comment (47 characters, cols. 34-80)
C       OUTPUT PARAMETERS
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        character*(*) keywrd,comm,strval
        integer ounit,status,lenval,ncomm,nvalue
        character value*70,keynam*8,cmnt*48
        
        if (status .gt. 0)return

        keynam=keywrd
        cmnt=comm

C       convert string to quoted character string (max length = 70 characters)
        call fts2c(strval,value,lenval,status)

C       find amount of space left for comment string
C       (assume 10 char. for 'keyword = ', and 3 between value and comment)
C       which leaves 67 spaces for the value string + comment string
        nvalue=max(20,lenval)
        ncomm=67-nvalue

C       write the keyword record
        if (ncomm .gt. 0)then
C         there is space for a comment
          call ftprec(ounit,
     &    keynam//'= '//value(1:nvalue)//' / '//cmnt(1:ncomm),status)
        else
C         no room for a comment
          call ftprec(ounit,
     &    keynam//'= '//value(1:nvalue)//'   ',status)
        end if  
        end
