C----------------------------------------------------------------------
        subroutine ftpclu(ounit,colnum,frow,felem,nelem,status)

C       set elements of a table to be undefined

C       ounit   i  fortran unit number
C       colnum  i  number of the column to write to
C       frow    i  first row to write
C       felem   i  first element within the row to write
C       nelem   i  number of elements to write
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ounit,colnum,frow,felem,nelem,status

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
        character snull*512,xdummy*5248
        common/ftheap/snull,xdummy
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bytpix,bstart,i4null,tcode,nchars,i,offset,nulval
        integer ibuff,ntodo,itodo,repeat,rstart,estart
        integer*2 i2null,i1null
        real r4null
        double precision r8null
        logical descrp

        if (status .gt. 0)return

C       check for zero length array
        if (nelem .le. 0)return
        if (frow .lt. 1)then
C               error: illegal first row number
                status=307
                return
        end if
        ibuff=bufnum(ounit)

        if (felem .lt. 1)then
C               illegal element number
                status=308
                return
        end if

        tcode=tdtype(colnum,ibuff)
        bytpix=max(abs(tcode)/10,1)

        descrp=.false.
        ntodo=nelem
        rstart=frow-1

        if (felem .lt. 1)then
C               illegal element number
                status=308
                return
        else
                estart=felem-1
        end if

        if (tcode .eq. 16)then
C               this is an ASCII field
                repeat=trept(colnum,ibuff)
                if (felem .gt. repeat)then
                        status=308
                        return
                end if

                if (cnull(colnum,ibuff) .eq. char(1))then
C                       error: null value has not been defined
                        status=314
                        return
                end if
C               the TNULL parameter stores the width of the character field
                bytpix=tnull(colnum,ibuff)
        else
C               this is a binary table
                nulval=tnull(colnum,ibuff)

                if (tcode .gt. 0)then
                        repeat=trept(colnum,ibuff)
                        if (felem .gt. repeat)then
C                               illegal element number
                                status=308
                                return
                        end if
                else
C                       this is a variable length descriptor column
                        descrp=.true.
                        tcode=-tcode
C                       read the number of elements and the starting offset:
                        call ftgdes(ounit,colnum,frow,repeat,
     &                              offset,status)
                        if (ntodo+estart .gt. repeat)then
C                               error:  tried to write past end of record
                                status=319
                                return
                        end if

C                       move the i/o pointer to the start of the pixel sequence
                        bstart=dtstrt(ibuff)+offset+
     &                          theap(ibuff)+estart*bytpix
                        call ftmbyt(ounit,bstart,.true.,status)
                end if

                if (tcode.eq.11 .or. tcode.eq.21 .or. tcode.eq.41)then
                        if (nulval .eq. 123454321)then
C                               error: null value has not been defined
                                status=314
                                return
                        end if
                else
C                       set the floating point Not-a-Number values
                        call ftsrnn(r4null)
                        call ftsdnn(r8null)
                end if

        end if

C       process as many contiguous pixels as possible
20      itodo=min(ntodo,repeat-estart)

        if (.not. descrp)then
C           move the i/o pointer to the start of the sequence of pixels
            bstart=dtstrt(ibuff)+rstart*rowlen(ibuff)
     &             +tbcol(colnum,ibuff)+estart*bytpix
            call ftmbyt(ounit,bstart,.true.,status)
        end if

C       write the appropriate null value to the pixels
        if (tcode .eq. 21)then
C               column data type is I (I*2)
                do 5 i=1,itodo
                        i2null=nulval
                        call ftpi2b(ounit,1,0,i2null,status)
5               continue
        else if (tcode .eq. 41)then
C               column data type is J (I*4)
                do 15 i=1,itodo
                        i4null=nulval
                        call ftpi4b(ounit,1,0,i4null,status)
15              continue
        else if (tcode .eq. 42)then
C               column data type is E (R*4)
                do 25 i=1,itodo
                        call ftpbyt(ounit,4,r4null,status)
25              continue
        else if (tcode .eq. 82 .or. tcode .eq. 83)then
C               column data type is D (R*8), or C complex 2 x R*4
                do 35 i=1,itodo
                        call ftpbyt(ounit,8,r8null,status)
35              continue
        else if (tcode .eq. 16)then
C               this is an ASCII table column
                snull=cnull(colnum,ibuff)
C               write up to 512 characters in the column, remainder unchanged
                nchars=min(bytpix,512)
                do 45 i=1,itodo
                        call ftpcbf(ounit,1,nchars,snull,status)
45              continue
        else if (tcode .eq. 11)then
C               column data type is B (byte)
                i1null=nulval
C               make both bytes of the I*2 word identical, so it does not
C               matter what order they are in when one of them gets written
C               to the FITS file
                if (i1null .lt. 256)i1null=i1null*256+i1null
                do 55 i=1,itodo
                        call ftpbyt(ounit,1,i1null,status)
55              continue
        else if (tcode .eq. 163)then
C               column data type is double complex (M)
                do 65 i=1,itodo*2
                        call ftpbyt(ounit,8,r8null,status)
65              continue
        else if (tcode .eq. 14)then
C               column data type is logical (L)
                i1null=0
                do 85 i=1,itodo
                        call ftpbyt(ounit,1,i1null,status)
85              continue
        end if

C       find number of pixels left to do, and quit if none left
        ntodo=ntodo-itodo
        if (ntodo .gt. 0)then
C               increment the pointers
                estart=estart+itodo
                if (estart .eq. repeat)then
                        estart=0
                        rstart=rstart+1
                end if
                go to 20
        end if
        end
