C----------------------------------------------------------------------
        subroutine ftpcle(ounit,colnum,frow,felem,nelem,array,status)

C       write an array of real data values to the specified column of
C       the table.  

C       ounit   i  fortran unit number
C       colnum  i  number of the column to write to
C       frow    i  first row to write
C       felem   i  first element within the row to write
C       nelem   i  number of elements to write
C       array   r  array of data values to be written 
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ounit,colnum,frow,felem,nelem,status
        real array(*)

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
        character*1 chbuff(400),xdummy(5360)
        common/ftheap/chbuff,xdummy
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bufdim
        parameter (bufdim = 100)
        integer buffer(bufdim),bytpix,bstart,tcode,incre
        integer ibuff,i1,ntodo,itodo,repeat,rstart,estart,maxpix,ival
        real rval
        double precision scale,zero,dval
        character*40 sval
        logical tofits,lval,descrp
        integer*2 i2val
        character*1 i1val

        if (status .gt. 0)return

C       check for zero length array or bad first row number
        if (nelem .le. 0)return
        if (frow .lt. 1)then
C               error: illegal first row number
                status=307
                return
        end if

        ibuff=bufnum(ounit)

        descrp=.false.
        i1=1
        ntodo=nelem
        rstart=frow-1
        scale=tscale(colnum,ibuff)
        zero=tzero(colnum,ibuff)
        tcode=tdtype(colnum,ibuff) 
C       the data are being scaled from internal format to FITS:
        tofits=.true.

C       calculate the maximum number of column pixels which fit in buffer
        bytpix=max(abs(tcode)/10,1)
        maxpix=bufdim/bytpix*4

C       incre is the byte offset between consecutive pixels
        incre=0
        if (tcode .eq. 16)then
C               this is an ASCII table; table elements cannot be vectors
                repeat=1
                estart=0
        else
C               this is a binary table
                if (felem .lt. 1)then
C                       illegal element number
                        status=308
                        return
                else
                        estart=felem-1
                end if

                if (tcode .gt. 0)then
                        repeat=trept(colnum,ibuff)
                        if (felem .gt. repeat)then
C                               illegal element number
                                status=308
                                return
                        end if
                        if (repeat .eq. 1 .and. nelem .gt. 1)then
C                               write multiple rows of data at one time
                                incre=rowlen(ibuff)
                                repeat=maxpix
                                estart=0
                        end if
                else
C                       this is a variable length descriptor column
                        descrp=.true.
                        tcode=-tcode
                        repeat=nelem+felem-1
C                       write the number of elements and the starting offset:
                        call ftpdes(ounit,colnum,frow,repeat,
     &                              nxheap(ibuff),status)
C                       move the i/o pointer to the start of the pixel sequence
                        bstart=dtstrt(ibuff)+nxheap(ibuff)+
     &                          theap(ibuff)+estart*bytpix
                        call ftmbyt(ounit,bstart,.true.,status)
C                       increment the empty heap starting address:
                        nxheap(ibuff)=nxheap(ibuff)+repeat*bytpix
                end if
        end if

C       process as many contiguous pixels as possible, up to buffer size
20      itodo=min(ntodo,repeat-estart,maxpix)

        if (.not. descrp)then
C           move the i/o pointer to the start of the sequence of pixels
            bstart=dtstrt(ibuff)+rstart*rowlen(ibuff)
     &             +tbcol(colnum,ibuff)+estart*bytpix
            call ftmbyt(ounit,bstart,.true.,status)
        end if

C       copy data to buffer, doing scaling and datatype conversion, if required
        if (tcode .eq. 21)then
C               column data type is I (I*2)
                call ftr4i2(array(i1),itodo,scale,zero,tofits,
     &          ival,i2val,lval,lval,buffer)
C               do any machine dependent data conversion and write the I*2 data
                call ftpi2b(ounit,itodo,incre,buffer,status)
        else if (tcode .eq. 41)then
C               column data type is J (I*4)
                call ftr4i4(array(i1),itodo,scale,zero,tofits,
     &          ival,ival,lval,lval,buffer)
C               do any machine dependent data conversion and write the I*4 data
                call ftpi4b(ounit,itodo,incre,buffer,status)
        else if (tcode .eq. 42)then
C               column data type is E (R*4)
                call ftr4r4(array(i1),itodo,scale,zero,tofits,
     &          ival,rval,lval,lval,buffer)
C               do any machine dependent data conversion and write the R*4 data
                call ftpr4b(ounit,itodo,incre,buffer,status)
        else if (tcode .eq. 82)then
C               column data type is D (R*8)
                call ftr4r8(array(i1),itodo,scale,zero,tofits,
     &          ival,dval,lval,lval,buffer)
C               do any machine dependent data conversion and write the R*8 data
                call ftpr8b(ounit,itodo,incre,buffer,status)
        else if (tcode .eq. 11)then
C               column data type is B (byte)
                call ftr4i1(array(i1),itodo,scale,zero,tofits,
     &          ival,i1val,lval,lval,chbuff)
C               do any machine dependent data conversion and write the byte data
                call ftpi1b(ounit,itodo,incre,chbuff,status)
        else if (tcode .eq. 16)then
C               this is an ASCII table column
                if (cform(colnum,ibuff)(1:1) .eq. 'I')then
C                 column data type is integer
                  call ftr4i4(array(i1),itodo,scale,zero,tofits,
     &            ival,ival,lval,lval,ival)
C                 create the formated character string
                  write(sval,'('//cform(colnum,ibuff)//')',err=900)ival
C                 write the character string to the FITS file
                  call ftpcbf(ounit,1,tnull(colnum,ibuff),sval,status)
                else if (cform(colnum,ibuff)(1:1) .eq. 'F'
     &            .or.  cform(colnum,ibuff)(1:1) .eq. 'E')then
C                 column data type is real
                  call ftr4r4(array(i1),itodo,scale,zero,tofits,
     &            ival,rval,lval,lval,rval)
C                 create the formated character string
                  write(sval,'('//cform(colnum,ibuff)//')',err=900)rval
C                 write the character string to the FITS file
                  call ftpcbf(ounit,1,tnull(colnum,ibuff),sval,status)
                else if (cform(colnum,ibuff)(1:1) .eq. 'D')then
C                 column data type is double precision
                  call ftr4r8(array(i1),itodo,scale,zero,tofits,
     &            ival,dval,lval,lval,dval)
C                 create the formated character string
                  write(sval,'('//cform(colnum,ibuff)//')',err=900)dval
C                 write the character string to the FITS file
                  call ftpcbf(ounit,1,tnull(colnum,ibuff),sval,status)
                else
C                 error: illegal ASCII table format code
                  status=311
                  return
                end if
        else
C               error illegal binary table data type code
                status=312
                return
        end if

C       find number of pixels left to do, and quit if none left
        ntodo=ntodo-itodo
        if (ntodo .gt. 0)then
C               increment the pointers
                i1=i1+itodo
                estart=estart+itodo
                if (estart .eq. repeat)then
                        estart=0
                        if (incre .eq. 0)then
                                rstart=rstart+1
                        else
                                rstart=rstart+repeat
                        end if
                end if
                go to 20
        end if
        return

900     continue
C       error writing formatted data value
        status=313
        end
