C----------------------------------------------------------------------
        subroutine ftpclc(ounit,colnum,frow,felem,nelem,array,status)

C       write an array of single precision complex data values to the 
C       specified column of the table.  
C       The binary table column being written to must have datatype 'C'
C       and no datatype conversion will be perform if it is not.

C       ounit   i  fortran unit number
C       colnum  i  number of the column to write to
C       frow    i  first row to write
C       felem   i  first element within the row to write
C       nelem   i  number of elements to write
C       array   cmp  array of data values to be written 
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ounit,colnum,frow,felem,nelem,status
C       the input array is really complex data type
        real array(*)

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bufdim
        parameter (bufdim = 200)
        integer buffer(bufdim),bytpix,bstart,tcode
        integer ibuff,i1,ntodo,itodo,repeat,rstart,estart,maxpix,ival
        real rval
        double precision scale,zero
        logical tofits,lval,descrp

        if (status .gt. 0)return

C       check for zero length array or bad first row number
        if (nelem .le. 0)return
        if (frow .lt. 1)then
C               error: illegal first row number
                status=307
                return
        end if

        ibuff=bufnum(ounit)

        i1=1
C       multiply by 2, because the complex data type has pairs of values
        ntodo=nelem*2
        rstart=frow-1
        scale=tscale(colnum,ibuff)
        zero=tzero(colnum,ibuff)
        tcode=tdtype(colnum,ibuff) 
C       the data are being scaled from internal format to FITS:
        tofits=.true.

        if (felem .lt. 1)then
C               illegal element number
                status=308
                return
        else
C               multiply by 2 because the complex data type has pairs of values
                estart=(felem-1)*2
        end if

C       calculate the maximum number of column pixels which fit in buffer
        bytpix=4
        maxpix=bufdim/bytpix*4

        if (tcode .eq. 83)then
                repeat=trept(colnum,ibuff)*2
                if (felem*2 .gt. repeat)then
C                       illegal element number
                        status=308
                        return
                end if
                descrp=.false.
        else if (tcode .eq. -83)then
C               this is a variable length descriptor column
                descrp=.true.
                repeat=nelem+felem-1
C               write the number of elements and the starting offset:
                call ftpdes(ounit,colnum,frow,repeat,
     &                              nxheap(ibuff),status)
                repeat=repeat*2
C               move the i/o pointer to the start of the pixel sequence
                bstart=dtstrt(ibuff)+nxheap(ibuff)+
     &                  theap(ibuff)+estart*bytpix
                call ftmbyt(ounit,bstart,.true.,status)
C               increment the empty heap starting address:
                nxheap(ibuff)=nxheap(ibuff)+repeat*bytpix
        else
C               error illegal table data type code
                status=312
                return
        end if

C       process as many contiguous pixels as possible, up to buffer size
20      itodo=min(ntodo,repeat-estart,maxpix)

        if (.not. descrp)then
C           move the i/o pointer to the start of the sequence of pixels
            bstart=dtstrt(ibuff)+rstart*rowlen(ibuff)
     &             +tbcol(colnum,ibuff)+estart*bytpix
            call ftmbyt(ounit,bstart,.true.,status)
        end if

C       copy data to buffer,
        call ftr4r4(array(i1),itodo,scale,zero,tofits,
     &          ival,rval,lval,lval,buffer)
C       do any machine dependent data conversion and write the R*4 data
        call ftpr4b(ounit,itodo,0,buffer,status)

C       find number of pixels left to do, and quit if none left
        ntodo=ntodo-itodo
        if (ntodo .gt. 0)then
C               increment the pointers
                i1=i1+itodo
                estart=estart+itodo
                if (estart .eq. repeat)then
                        estart=0
                        rstart=rstart+1
                end if
                go to 20
        end if
        end
