C------------------------------------------------------------------------------
C       The following routines are part of the FITSIO library
C       and are specific to SUN SPARC computers
C------------------------------------------------------------------------------
C   This software was prepared by High Energy Astrophysic Science Archive
C   Research Center (HEASARC) at the NASA Goddard Space Flight Center. Users
C   shall not, without prior written permission of the U.S. Government,
C   establish a claim to statutory copyright.  The Government and others acting
C   on its behalf, shall have a royalty-free, non-exclusive, irrevocable,
C   worldwide license for Government purposes to publish, distribute,
C   translate, copy, exhibit, and perform such material. 
C------------------------------------------------------------------------------
        subroutine ftopnx2(funit,fname,oldnew,rwmode,block,status)

C       low-level, machine-dependent routine to create and open a new file 
C       This is the SUN SPARC version.
C
C       funit   i  Fortran I/O unit number
C       fname   c  name of file to be opened
C       oldnew  i  file status: 0 = open old/existing file; else open new file
C       rwmode  i  file access mode: 0 = readonly; else = read/write
C       block   i  FITS record blocking factor 
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer funit,oldnew,rwmode,block,status
        integer i,ibuff
        character*(*) fname
        character fstat*7
        logical found

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C-------END OF COMMON BLOCK DEFINITIONS-----------------------------------

C       the following statement forces the BLOCK DATA FTBKDT module to be
C       loaded by the linker if it is not already loaded.
        external ftbkdt

        if (status .gt. 0)return

C       check for valid unit number
        if (funit .lt. 1 .or. funit .gt. 199)then
                status=101
                return
        end if

C       find available buffer slot for this file
        do 10 i=1,nb
                if (bufpnt(i) .eq. 0)then
                        ibuff=i
                        go to 20
                end if
10      continue

C       error: no vacant buffer slots left
        status=102
        return

20      continue
        if (oldnew .eq. 0)then
                fstat='OLD    '
C               test if file exists
                inquire(file=fname,exist=found)
                if (.not. found)then
C                       error: file doesn't exist??
                        status=103
                        return
                end if
C               The blocking factor is irrelevant for files on a this machine, 
C               therefore, simply return the default block size.
                block=1
        else
                fstat='UNKNOWN'
        end if
        
C       files do not have an intrinsic record length, so just use
C       the standard 2880-byte block length for convenience
        reclen(funit)=2880

        if (rwmode .eq. 0)then
                wrmode(ibuff)=.false.
        else
C               open file with read and write access
                wrmode(ibuff)=.true.
        end if

        open(unit=funit,file=fname,status=fstat,err=900,
     &       recl=2880,form='UNFORMATTED',access='DIRECT')

C       initialize various parameters about the CHDU
        recnum(ibuff)=0
        bytnum(ibuff)=0
        modify(ibuff)=.false.
        chdu(ibuff)=1
        maxhdu(ibuff)=1
        hdstrt(ibuff,1)=0
        hdend(ibuff)=0
        nxthdr(ibuff)=0
C       data start location is undefined
        dtstrt(ibuff)=-1000000000
C       store internal buffer number to use for this file
        bufnum(funit)=ibuff
C       store inverse pointer: tells which unit is attached to this buffer
        bufpnt(ibuff)=funit
        return

C       error opening file:
900     continue
        if (fstat .eq. 'OLD')then
                status=104
        else
                status=105
        end if
        end
