C--------------------------------------------------------------------------
        subroutine ftopen(funit,fname,rwmode,block,status)

C       open an existing FITS file with readonly or read/write access
C
C       funit   i  Fortran I/O unit number
C       fname   c  name of file to be opened
C       rwmode  i  file access mode: 0 = readonly; else = read and write
C       block   i  returned record length blocking factor
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer funit,rwmode,block,status
        character*(*) fname

        if (status .gt. 0)return

        if (fname .eq. ' ')then
                status=104
                return
        end if

C       call the machine dependent routine which actually opens the file
        call ftopnx(funit,fname,0,rwmode,block,status)

C       determine the structure and size of the primary HDU
        call ftpini(funit,status)
        end
