C--------------------------------------------------------------------------
        subroutine ftnulc(input,n,chktyp,setval,flgray,anynul)

C       check input complex array for nulls
C       if chktyp=1 then set the undefined pixel = SETVAL
C       if chktyp=2 then set the corresponding FLGRAY = .true.

C       input   r  input array of values
C       n       i  number of values 
C       chktyp  i  type of null value checking to be done if TOFITS=.false.
C                       =1  set null values = SETVAL
C                       =2  set corresponding FLGRAY value = .true.
C       setval  r  value to set output array to if value is undefined
C       flgray  l  array of logicals indicating if corresponding value is null
C       anynul  l  set to true if any nulls were set in the output array

        real input(*),setval(2)
        integer n,i,chktyp,n2
        logical flgray(*),anynul
        logical fttrnn
        external fttrnn
        
        if (chktyp .eq. 2)then
C               initialize the null flag values
                do 5 i=1,n/2
                        flgray(i)=.false.
5               continue
        end if

        do 10 i=1,n
                if (fttrnn(input(i)))then
                        anynul=.true.
                        if (chktyp .eq. 1)then
                                n2=(i-1)/2*2+1
C                               set both parts of the complex number to the
C                               specified special value
                                input(n2)=setval(1)
                                input(n2+1)=setval(2)
                        else
C                               set the corresponding flag value to true
                                n2=(i-1)/2+1
                                flgray(n2)=.true.
                        end if
                end if
10      continue
        end
