C----------------------------------------------------------------------
        subroutine ftmoff(iunit,offset,igneof,status)

C       move i/o pointer by the specified byte offset.
C       Subsequent read or write operations will begin at this point.

C       iunit   i  fortran unit number
C       offset  i  number of bytes to move the pointer
C       igneof  l  should end-of-file error (107) be ignored?
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June, 1991

        integer iunit,offset,status
        logical igneof

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bytno,nbuff,record,bytoff

        if (status .gt. 0)return

        nbuff=bufnum(iunit)
        bytno=(recnum(nbuff)-1)*reclen(iunit)+bytnum(nbuff)+offset
        if (bytno .lt. 0)then
C               error: negative byte number
                status=304
                return
        end if

C       calculate the record number and byte within the record to move to

        record=bytno/reclen(iunit)+1
        bytoff=mod(bytno,reclen(iunit))

        if (record .ne. recnum(nbuff))then
C               read in the new record, but first, check if the current
C               record has been modified.  If so, write it to disk.
                if (modify(nbuff))then
                        call ftpbyx(iunit,recnum(nbuff),
     &                  reclen(iunit),nbuff,status)
                        if (status .gt. 0)return
                        modify(nbuff)=.false.
                end if
C               now read new record from disk; 
                recnum(nbuff)=record
                call ftgbyx(iunit,record,
     &                  reclen(iunit),nbuff,status)
                if (status .gt. 0)then
C                       We have just initialize this new record, so set modify
                        if (wrmode(nbuff))then
                             modify(nbuff)=.true.
                        end if
C                       ignore end of file error message
                        if (igneof .and. status .eq. 107)status=0
                end if
        end if
C       set the pointer to the correct byte within the record
        bytnum(nbuff)=bytoff
        end
