C----------------------------------------------------------------------
        subroutine ftmbyt(iunit,bytno,igneof,status)

C       move i/o pointer so that it is pointing to the byte number BYTNUM
C       in the FITS file.  Subsequent read or write operations will begin
C       at this point.

C       iunit   i  fortran unit number
C       bytno   i  number of the byte to point to.
C       igneof  l  ignore end-of-file (107) error?
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June, 1991

        integer iunit,bytno,status
        logical igneof

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer nbuff,record,bytoff

        if (status .gt. 0)then
                return
        else if (bytno .lt. 0)then
C               error: negative byte number
                status=304
                return
        else

        nbuff=bufnum(iunit)

C       calculate the record number and byte within the record to move to

        record=bytno/reclen(iunit)+1
        bytoff=mod(bytno,reclen(iunit))

        if (record .ne. recnum(nbuff))then
C               read in the new record, but first, check if the current

C       if record has been modified write it to disk if we have write access
                if (modify(nbuff))then
                        if (wrmode(nbuff))then
                                call ftpbyx(iunit,recnum(nbuff),
     &                          reclen(iunit),nbuff,status)
                                if (status .gt. 0)return
                                modify(nbuff)=.false.
                        else
C                               error: file only has read access; can't modify
                                status=112
                                return
                        end if
                end if
C               now read new record from disk; 
                recnum(nbuff)=record
                call ftgbyx(iunit,record,
     &                  reclen(iunit),nbuff,status)
                if (status .gt. 0)then
C                       We have just initialized this new record, so set modify
                        if (wrmode(nbuff))then
                             modify(nbuff)=.true.
                        end if
C                       ignore end of file error message
                        if (igneof .and. status .eq. 107)status=0
                end if
        end if
C       set the pointer to the correct byte within the record
        bytnum(nbuff)=bytoff
        end if
        end
