C----------------------------------------------------------------------
        subroutine ftmahd(iunit,extno,xtend,status)

C       Move to Absolute Header Data unit
C       move the i/o pointer to the specified HDU and initialize all
C       the common block parameters which describe the extension

C       iunit   i  fortran unit number
C       extno   i  number of the extension to point to.
C       xtend   i  returned type of extension:   0 = the primary HDU
C                                                1 = an ASCII table
C                                                2 = a binary table
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June, 1991

        integer iunit,extno,xtend,status

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer ibuff,i,nloop

        ibuff=bufnum(iunit)

C       first, close out the current HDU before moving to the new one
        call ftchdu(iunit,status)

C       check if we know where this extension begins
        if (extno .le. maxhdu(ibuff)+1)then
C               yes; so go directly to this extension
                call ftgext(iunit,extno,xtend,status)
        else
C               we have to read through the file to find this extension
                nloop=extno-maxhdu(ibuff)
                do 10 i=1,nloop
                    call ftgext(iunit,maxhdu(ibuff)+1,xtend,status)
                    if (status .ne. 0)return
10              continue
        end if
        end        
