C--------------------------------------------------------------------------
        subroutine ftiblk(ounit,status)

C       attempt to insert a blank-filled 2880-byte block at the end
C       of the CHU, to create space for more header records.

C       ounit   i  fortran output unit number
C       status  i  returned error status (0=ok)

        integer ounit,status

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        character*2880 buff(2)
        common/ftheap/buff
C       END OF COMMON BLOCK DEFINITIONS:------------------------------------

        integer ibuff,jpoint,in,out,i

        if (status .gt. 0)return

C       get the number of the data buffer used for this unit
        ibuff=bufnum(ounit)

C       initialize the first buffer
        buff(1)=' '

        jpoint=dtstrt(ibuff)
        in=2
        out=1

C       move to the read start position
10      call ftmbyt(ounit,jpoint,.false.,status)

C       read one 2880-byte FITS logical record into the input buffer
        call ftgcbf(ounit,0,2880,buff(in),status)

C       check for End-Of-File
        if (status .eq. 107)go to 20

C       move back to the write start postion
        call ftmbyt(ounit,jpoint,.false.,status)

C       write the 2880-byte FITS logical record stored in the output buffer
        call ftpcbf(ounit,0,2880,buff(out),status)

C       check for error during write (the file may not have write access)
        if (status .gt. 0)return

C       swap the input and output buffer pointers and move to next block
        if (in .eq. 1)then
                in=2
                out=1
        else
                in=1
                out=2
        end if
        jpoint=jpoint+2880

C       now repeat the process until we reach the End-Of-File
        go to 10

20      continue
C       we have reached the end of file; now append the last block to the file
        status=0

C       move back to the write start postion
        call ftmbyt(ounit,jpoint,.true.,status)

C       write the 2880-byte FITS logical record stored in the output buffer
        call ftpcbf(ounit,0,2880,buff(out),status)

        if (status .le. 0)then
C               recalculate the starting location of the current data unit
                dtstrt(ibuff)=dtstrt(ibuff)+2880

C               recalculate the starting location of all subsequent HDUs
                do 30 i=chdu(ibuff)+1,maxhdu(ibuff)+1
                        hdstrt(ibuff,i)=hdstrt(ibuff,i)+2880
30              continue
        end if
        end
