C----------------------------------------------------------------------
        subroutine ftgr8b(iunit,nvals,incre,r8vals,status)

C       Read an array of Real*8 bytes from the input FITS file.
C       Does any required translation from FITS to internal machine format.

        integer nvals,iunit,incre,status,i,offset
        double precision r8vals(nvals)

C       nvals   i  number of pixels to read
C       iunit   i  fortran unit number
C       incre   i  byte increment between values
C       r8vals  d  output array of real*8 values
C       status  i  output error status

        if (incre .le. 8)then
                call ftgbyt(iunit,nvals*8,r8vals,status)
        else
C               offset is the number of bytes to move between each value
                offset=incre-8
                do 10 i=1,nvals
                        call ftgbyt(iunit,8,r8vals(i),status)
                        call ftmoff(iunit,offset,.false.,status)                
10              continue
        end if
        end
