C----------------------------------------------------------------------
        subroutine ftgphx(iunit,maxdim,simple,bitpix,naxis,naxes,pcount
     &               ,gcount,extend,bscale,bzero,blank,nblank,status)

C       get the main primary header keywords which define the array structure
C
C       iunit   i  fortran unit number to use for reading
C       maxdim  i  maximum no. of dimensions to read; dimension of naxes
C       OUTPUT PARAMETERS:
C       simple  l  does file conform to FITS standard?
C       bitpix  i  number of bits per data value
C       naxis   i  number of axes in the data array
C       naxes   i  array giving the length of each data axis
C       pcount  i  number of group parameters (usually 0)
C       gcount  i  number of random groups (usually 1 or 0)
C       extend  l  may extensions be present in the FITS file?
C       bscale  d  scaling factor
C       bzero   d  scaling zero point
C       blank   i  value used to represent undefined pixels
C       nblank  i  number of trailing blank keywords immediately before the END
C       status  i  output error status (0=OK)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,maxdim,bitpix,naxis
        integer naxes(*),pcount,gcount,blank,status
        logical simple,extend
        character keynam*8,value*20,comm*48
        double precision bscale,bzero
        integer nkey,nblank,i,ibuff,taxes,maxd

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        if (status .gt. 0)return

        ibuff=bufnum(iunit)

C       check that the first keyword is valid
        call ftgkyn(iunit,1,keynam,value,comm,status)
        if (status .gt. 0)return

        if (chdu(ibuff) .eq. 1)then
            if (keynam .eq. 'SIMPLE')then
                if (value .eq. 'T')then
                        simple=.true.
                else if (value .eq. 'F')then
C                       this is not a simple FITS file; try to process it anyway
                        simple=.false.
                else
C                       illegal value for the SIMPLE keyword
                        status=220
                end if
            else
                status=221
                go to 900
            end if
        else
             if (keynam .eq. 'XTENSION')then
                if (value(2:9) .ne. 'IMAGE   ' .and. 
     &              value(2:9) .ne. 'IUEIMAGE')then
                        status=233
                        go to 900
                 end if
                 simple=.true.
             else
                 status=225
             end if
        end if

C       check that BITPIX is the second keyword
        call ftgkyn(iunit,2,keynam,value,comm,status)
        if (status .gt. 0)go to 900
        if (keynam .ne. 'BITPIX')then
                status=222
                go to 900
        end if
C       convert character string to integer
        call ftc2ii(value,bitpix,status)
        if (status .gt. 0)then
C               bitpix value must be an integer
                status=211
        end if

C       test that bitpix has a legal value
        call fttbit(bitpix,status)

C       check that the third keyword is NAXIS
        call ftgtkn(iunit,3,'NAXIS',naxis,status)
        if (status .eq. 208)then
C               third keyword was not NAXIS
                status=223
        else if (status .eq. 209)then
C               NAXIS value was not an integer
                status=212
        end if
        if (status .gt. 0)go to 900

        if (maxdim .le. 0)then
                maxd=naxis
        else
                maxd=min(maxdim,naxis)
        end if

        do 10 i=1,naxis
C               construct keyword name
                call ftkeyn('NAXIS',i,keynam,status)
C               attempt to read the keyword
                call ftgkyj(iunit,keynam,taxes,comm,status)
                if (status .gt. 0)then
                        status=224
                        return
                end if

                if (taxes .lt. 0)then
C                       NAXISn keywords must not be negative
                        status=213
                        return
                else if (i .le. maxd)then
                        naxes(i)=taxes
                end if
10      continue

C       now look for other keywords of interest: bscale, bzero, blank, and END
C       and pcount, gcount, and extend
15      bscale=1.
        bzero=0.
        pcount=0
        gcount=1
        extend=.false.
C       choose a special value to represent the absence of a blank value
        blank=123454321

        nkey=3+naxis
18      nblank=0
20      nkey=nkey+1
        call ftgkyn(iunit,nkey,keynam,value,comm,status)
        if (status .gt. 0)go to 900

        if (keynam .eq. 'BSCALE')then
C               convert character string to floating pt.
                call ftc2dd(value,bscale,status)
        else if (keynam .eq. 'BZERO')then
C               convert character string to floating pt.
                call ftc2dd(value,bzero,status)
        else if (keynam .eq. 'BLANK')then
C               convert character string to integer
                call ftc2ii(value,blank,status)
        else if (keynam .eq. 'PCOUNT')then
C               convert character string to integer
                call ftc2ii(value,pcount,status)
        else if (keynam .eq. 'GCOUNT')then
C               convert character string to integer
                call ftc2ii(value,gcount,status)
        else if (keynam .eq. 'EXTEND')then
C               convert character string to logical
                call ftc2ll(value,extend,status)
        else if (keynam .eq. ' ' .and. comm .eq. ' ')then
C               need to ignore trailing blank records before the END card
                nblank=nblank+1
                go to 20
        else if (keynam .eq. 'END')then
                go to 900
        end if
        if (status .gt. 0)go to 900
        go to 18

900     continue
        end
