C--------------------------------------------------------------------------
        subroutine ftgkyn(iunit,nkey,keynam,value,comm,status)

C       Read value and comment of the NKEYth header record 
C       This routine is useful for reading the entire header, one
C       record at a time.

C       iunit   i  Fortran I/O unit number
C       nkey    i  sequence number (starting with 1) of the keyword to read
C       OUTPUT PARAMETERS:
C       keynam  c  output name of the keyword
C       value   c  output value of the keyword, if any
C       comm    c  output comment string, if any, of the keyword
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,nkey,status
        character*(*) keynam
        character*(*) value,comm
        character*80 keybuf

        if (status .gt. 0)return

        call ftgrec(iunit,nkey,keybuf,status)

        keynam=keybuf(1:8)
C       parse the value and comment fields from the record
        call ftpsvc(keybuf,value,comm,status)

        end
