C--------------------------------------------------------------------------
        subroutine ftgcno(iunit,exact,colnam,colnum,status)

C       determine the column number corresponding to an input column name.
C       this assumes that the first 16 characters uniquely define the name

C       iunit   i  Fortran i/o unit number
C       exact   l  true if an exact case match of the names is required
C       colnam  c  name of column as specified in a TTYPE keyword
C       colnum  i  number of the column (first column = 1)
C                       (a value of 0 is returned if the column is not found)
C       status  i  returned error status

        integer iunit,colnum,status
        character*(*) colnam
        logical exact

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
C       END OF COMMON BLOCK DEFINITIONS------------------------------------

        integer ibuff,i,nfound
        character*16 tname,cname

        if (status .ne. 0)return
        ibuff=bufnum(iunit)

        cname=colnam
C       force to uppercase, unless exact case match is required
        if (.not. exact)then
                call ftupch(cname)
        end if

C       look for the name in the value of the TTYPE keywords
        do 10 i=1,tfield(ibuff)
                call ftgkns(iunit,'TTYPE',i,1,tname,nfound,status)
                if (status .ne. 0)return
                if (nfound .eq. 1)then
C                       force to uppercase, unless exact case match is required
                        if (.not. exact)then
                                call ftupch(tname)
                        end if
                        if (tname .eq. cname)then
                                colnum=i
                                return
                        end if
                end if
10      continue

C       error: couldn't find the named column
        status=219
        colnum=0
        end        
