C----------------------------------------------------------------------
        subroutine ftgcld(iunit,colnum,frow,felem,nelem,
     &   nultyp,nulval,array,flgval,anynul,status)

C       read an array of real*8 data values from the specified column of
C       the table.  
C       This general purpose routine will handle null values in one
C       of two ways: if nultyp=1, then undefined array elements will be
C       set equal to the input value of NULVAL.  Else if nultyp=2, then
C       undefined array elements will have the corresponding FLGVAL element
C       set equal to .TRUE.  If NULTYP=1 and NULVAL=0, then no checks for
C       undefined values will be made, for maximum efficiency.

C       iunit   i  fortran unit number
C       colnum  i  number of the column to read from
C       frow    i  first row to read
C       felem   i  first element within the row to read
C       nelem   i  number of elements to read
C       nultyp  i  input code indicating how to handle undefined values
C       nulval  d  value that undefined pixels will be set to (if nultyp=1)
C       array   d  array of data values that are read from the FITS file
C       flgval  l  set .true. if corresponding element undefined (if nultyp=2)
C       anynul  l  set to .true. if any of the returned values are undefined
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,colnum,frow,felem,nelem,nultyp,status
        double precision array(*),nulval
        logical flgval(*),anynul

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
        character*1 chbuff(400),xdummy(5360)
        common/ftheap/chbuff,xdummy
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bufdim
        parameter (bufdim = 100)
        integer buffer(bufdim),bytpix,bstart,tcode,i4null,nulchk,incre
        integer ibuff,i1,ntodo,itodo,repeat,rstart,estart,maxpix,ival
        integer offset
        integer*2 i2null
        character*1 i1null
        real rval
        double precision scale,zero,dval
        character sval*40,sform*13,snull*8
        logical tofits,descrp
        
        if (status .gt. 0)return

C       check for zero length array or bad first row number
        if (nelem .le. 0)return
        if (frow .lt. 1)then
C               error: illegal first row number
                status=307
                return
        end if

        descrp=.false.
        i1=1
        ntodo=nelem
        rstart=frow-1
        anynul=.false.
        ibuff=bufnum(iunit)
        tcode=tdtype(colnum,ibuff)
        scale=tscale(colnum,ibuff)
        zero=tzero(colnum,ibuff)
C       the data are being scaled from FITS to internal format 
        tofits=.false.

C       calculate the maximum number of column pixels which fit in buffer
        bytpix=max(abs(tcode)/10,1)
C       check for important special case: no datatype conversion required
        if (abs(tcode) .eq. 82)then
                maxpix=nelem
        else
                maxpix=bufdim/bytpix*4
        end if

C       determine the repeat count and the first element position
C       incre is the byte offset between consecutive pixels
        incre=0                
        if (tcode .eq. 16)then
C               this is an ASCII table; table elements cannot be vectors
                repeat=1
                estart=0
C               construct the read format, and get the null value string
                sform='(BN,'//cform(colnum,ibuff)//')'
                snull=cnull(colnum,ibuff)                
        else
C               this is a binary table
                if (felem .lt. 1)then
C                       illegal element number
                        status=308
                        return
                else
                        estart=felem-1
                end if

                if (tcode .gt. 0)then
                        repeat=trept(colnum,ibuff)
                        if (felem .gt. repeat)then
C                               illegal element number
                                status=308
                                return
                        end if
                        if (repeat .eq. 1 .and. nelem .gt. 1)then
C                               read multiple rows of data at one time
                                incre=rowlen(ibuff)
                                repeat=maxpix
                                estart=0
                        end if
                else
C                       this is a variable length descriptor column
                        descrp=.true.
                        tcode=-tcode
C                       read the number of elements and the starting offset:
                        call ftgdes(iunit,colnum,frow,repeat,
     &                              offset,status)
                        if (repeat .eq. 0)then
C                               error: null length vector
                                status=318
                                return
                        else if (estart+nelem .gt. repeat)then
C                               error: trying to read beyond end of record
                                status=319
                                return
                        end if
C                       move the i/o pointer to the start of the pixel sequence
                        bstart=dtstrt(ibuff)+offset+
     &                          theap(ibuff)+estart*bytpix
                        call ftmbyt(iunit,bstart,.true.,status)
                end if
        end if

C       determine if we have to check for null values
        if (nultyp .eq. 1 .and. nulval .eq. 0)then
C               user doesn't want to check for nulls
                nulchk=0
        else
C           user does want to check for null values
C           see if the null value has been defined for this column
            nulchk=0
            if (tcode .eq. 11)then
C               check if byte datatype null value is defined, 
                if (tnull(colnum,ibuff).ne.123454321)then
                        i1null=char(tnull(colnum,ibuff))
                        nulchk=nultyp
                end if
            else if (tcode .eq. 21)then
C               check if I*2 datatype null value is defined, 
                if (tnull(colnum,ibuff).ne.123454321)then
                        i2null=tnull(colnum,ibuff)
                        nulchk=nultyp
                end if
            else if (tcode .eq. 41)then
C               check if I*4 datatype null value is defined, 
                if (tnull(colnum,ibuff).ne.123454321)then
                        i4null=tnull(colnum,ibuff)
                        nulchk=nultyp
                end if
            else if (tcode .eq. 42 .or. tcode .eq. 82)then
C               have to check floating point data for NaN values
                nulchk=nultyp
            end if
        end if

C       process as many contiguous pixels as possible, up to buffer size
20      itodo=min(ntodo,repeat-estart,maxpix)

        if (.not. descrp)then
C           move the i/o pointer to the start of the sequence of pixels
            bstart=dtstrt(ibuff)+rstart*rowlen(ibuff)+
     &             tbcol(colnum,ibuff)+estart*bytpix
            call ftmbyt(iunit,bstart,.false.,status)
        end if

C       read the data from FITS file, doing datatype conversion and scaling
        if (tcode .eq. 21)then
C               column data type is I (I*2)
C               read the data and do any machine dependent data conversion
                call ftgi2b(iunit,itodo,incre,buffer,status)
C               check for null values, and do scaling and datatype conversion
                call fti2r8(buffer,itodo,scale,zero,tofits,
     &          nulchk,i2null,nulval,flgval(i1),anynul,array(i1))
        else if (tcode .eq. 41)then
C               column data type is J (I*4)
C               read the data and do any machine dependent data conversion
                call ftgi4b(iunit,itodo,incre,buffer,status)
C               check for null values, and do scaling and datatype conversion
                call fti4r8(buffer,itodo,scale,zero,tofits,
     &          nulchk,i4null,nulval,flgval(i1),anynul,array(i1))
        else if (tcode .eq. 42)then
C               column data type is E (R*4)
C               read the data and do any machine dependent data conversion
                call ftgr4b(iunit,itodo,incre,buffer,status)
C               check for null values, and do scaling and datatype conversion
                call ftr4r8(buffer,itodo,scale,zero,tofits,
     &          nulchk,nulval,flgval(i1),anynul,array(i1))
        else if (tcode .eq. 82)then
C               column data type is D (R*8)
C               read the data and do any machine dependent data conversion
C               note that we can use the input array directly
                call ftgr8b(iunit,itodo,incre,array(i1),status)
C               check for null values, and do scaling and datatype conversion
                call ftr8r8(array(i1),itodo,scale,zero,tofits,
     &          nulchk,nulval,flgval(i1),anynul,array(i1))
        else if (tcode .eq. 11)then
C               column data type is B (byte)
C               read the data 
                call ftgi1b(iunit,itodo,incre,chbuff,status)
C               check for null values, and do scaling and datatype conversion
                call fti1r8(chbuff,itodo,scale,zero,tofits,
     &          nulchk,i1null,nulval,flgval(i1),anynul,array(i1))
        else if (tcode .eq. 16)then
C               this is an ASCII table column; get the character string
                call ftgcbf(iunit,1,tnull(colnum,ibuff),sval,status)
                if (status .gt. 0)return

C               check for null
                if (sval(1:8) .eq. snull)then
                        anynul=.true.
                        if (nultyp .eq. 1)then
                                array(i1)=nulval
                        else
                                flgval(i1)=.true.
                        end if
                        go to 30
                end if

C               now read the value, then do scaling and datatype conversion
                if (sform(5:5) .eq. 'I')then
                        read(sval,sform,err=900)ival
                        call fti4r8(ival,itodo,scale,zero,tofits,
     &                  0,i4null,nulval,flgval(i1),anynul,array(i1))
                else if (sform(5:5).eq.'F'.or. sform(5:5).eq.'E')then
                        read(sval,sform,err=900)rval
                        call ftr4r8(rval,itodo,scale,zero,tofits,
     &                  0,nulval,flgval(i1),anynul,array(i1))
                else if (sform(5:5) .eq. 'D')then
                        read(sval,sform,err=900)dval
                        call ftr8r8(dval,itodo,scale,zero,tofits,
     &                  0,nulval,flgval(i1),anynul,array(i1))
                else
C                       error: illegal ASCII table format code
                        status=311
                        return
                end if
        else
C               error illegal binary table data type code
                status=312
                return
        end if

C       find number of pixels left to do, and quit if none left
30      ntodo=ntodo-itodo
        if (ntodo .gt. 0)then
C               increment the pointers
                i1=i1+itodo
                estart=estart+itodo
                if (estart .eq. repeat)then
                        estart=0
                        if (incre .eq. 0)then
                                rstart=rstart+1
                        else
                                rstart=rstart+repeat
                        end if
                end if
                go to 20
        end if
        return

900     continue
C       error reading formatted data value
        status=315
        end
