C----------------------------------------------------------------------
        subroutine ftgclc(iunit,colnum,frow,felem,nelem,
     &   nultyp,nulval,array,flgval,anynul,status)

C       read an array of complex data values from the specified column of
C       the table.  
C       This general purpose routine will handle null values in one
C       of two ways: if nultyp=1, then undefined array elements will be
C       set equal to the input value of NULVAL.  Else if nultyp=2, then
C       undefined array elements will have the corresponding FLGVAL element
C       set equal to .TRUE.  If NULTYP=1 and NULVAL=0, then no checks for
C       undefined values will be made, for maximum efficiency.
C       The binary table column being read to must have datatype 'C'
C       and no datatype conversion will be perform if it is not.

C       iunit   i  fortran unit number
C       colnum  i  number of the column to read from
C       frow    i  first row to read
C       felem   i  first element within the row to read
C       nelem   i  number of elements to read
C       nultyp  i  input code indicating how to handle undefined values
C       nulval  cm  value that undefined pixels will be set to (if nultyp=1)
C       array   cm  array of data values that are read from the FITS file
C       flgval  l  set .true. if corresponding element undefined (if nultyp=2)
C       anynul  l  set to .true. if any of the returned values are undefined
C       status  i  output error status
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,colnum,frow,felem,nelem,nultyp,status
        real array(*),nulval(2)
        logical flgval(*),anynul

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer bytpix,bstart,tcode,nulchk,offset
        integer ibuff,i1,ntodo,itodo,repeat,rstart,estart

        logical descrp
        
        if (status .gt. 0)return

C       check for zero length array or bad first row number
        if (nelem .le. 0)return
        if (frow .lt. 1)then
C               error: illegal first row number
                status=307
                return
        end if

C       determine the repeat count and the first element position
        if (felem .lt. 1)then
C               illegal element number
                status=308
                return
        else
                estart=(felem-1)*2
        end if

        i1=1
        ntodo=nelem*2
        rstart=frow-1
        anynul=.false.
        ibuff=bufnum(iunit)
        tcode=tdtype(colnum,ibuff)
        bytpix=4

        if (tcode .eq. 83)then
                repeat=trept(colnum,ibuff)*2
                if (felem*2 .gt. repeat)then
C                               illegal element number
                                status=308
                                return
                end if
                descrp=.false.
        else if (tcode .eq. -83)then
C               this is a variable length descriptor column
                descrp=.true.
C               read the number of elements and the starting offset:
                call ftgdes(iunit,colnum,frow,repeat,
     &                              offset,status)
                repeat=repeat*2
                if (repeat .eq. 0)then
C                       error: null length vector
                        status=318
                        return
                else if (estart+ntodo .gt. repeat)then
C                       error: trying to read beyond end of record
                        status=319
                        return
                end if
C               move the i/o pointer to the start of the pixel sequence
                bstart=dtstrt(ibuff)+offset+
     &                          theap(ibuff)+estart*bytpix
                call ftmbyt(iunit,bstart,.true.,status)
        else
C               column must be complex data type
                status=312
                return
        end if

C       determine if we have to check for null values
        if (nultyp .eq. 1 .and. nulval(1) .eq. 0 .and.
     &      nulval(2) .eq. 0)then
C               user doesn't want to check for nulls
                nulchk=0
        else
C               have to check floating point data for NaN values
                nulchk=nultyp
        end if

C       process as many contiguous pixels as possible, up to buffer size
20      itodo=min(ntodo,repeat-estart)

        if (.not. descrp)then
C           move the i/o pointer to the start of the sequence of pixels
            bstart=dtstrt(ibuff)+rstart*rowlen(ibuff)+
     &             tbcol(colnum,ibuff)+estart*bytpix
            call ftmbyt(iunit,bstart,.false.,status)
        end if

C       read the data 
        call ftgr4b(iunit,itodo,0,array(i1),status)
C       check for null values
        if (nulchk .ne. 0)then
          call ftnulc(array(i1),itodo,nulchk,nulval,flgval(i1),anynul)
        end if

C       find number of pixels left to do, and quit if none left
30      ntodo=ntodo-itodo
        if (ntodo .gt. 0)then
C               increment the pointers
                i1=i1+itodo
                estart=estart+itodo
                if (estart .eq. repeat)then
                        estart=0
                        rstart=rstart+1
                end if
                go to 20
        end if

        end
