C--------------------------------------------------------------------------
        subroutine ftgcbf(iunit,convrt,nchar,array,status)

C       "Get Character BuFfer"
C       read NCHAR characters from the character buffer.
C       If buffer is empty, then read in another block of data from the
C       disk file.
C       If nchar=0, then simply flush out any remaining characters in the
C           the current block of data.
C
C       iunit   i  Fortran unit number for reading from disk
C       convrt  i  whether (=1) or not (=0) to convert from ASCII
C               (this only applies to machines that do not use the
C                ASCII sequence for their native character representation)
C       nchar   i  number of characters to read
C       array   c  output character string
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,convrt,nchar,status
        character*(*) array
        integer nleft,nbyt,lastb,in1,nbuff,buflen

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid

        character*2880 buff1,buff2,buff3,buff4,buff5,buff6
        character*2880 buff7,buff8,buff9,buff10,buff11,buff12
        common/ft00b1/buff1
        common/ft00b2/buff2
        common/ft00b3/buff3
        common/ft00b4/buff4
        common/ft00b5/buff5
        common/ft00b6/buff6
        common/ft00b7/buff7
        common/ft00b8/buff8
        common/ft00b9/buff9
        common/ft0b10/buff10
        common/ft0b11/buff11
        common/ft0b12/buff12
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        if (status .gt. 0)return

        if (nchar .lt. 0)then
C               error: negative number of bytes to read
                status=306
                return
        end if

        nbuff=bufnum(iunit)
        buflen=reclen(iunit)

C       lastb   = position of last byte read from input buffer
C       nleft   = number of bytes left in the input buffer
C       in1     = position of first byte remaining in the input buffer
C       nbyt    = number of bytes to transfer from input to output

        lastb=bytnum(nbuff)
        nleft=nchar
        in1=1

C       find the number of remaining bytes that can be read from buffer
10      nbyt=min(nleft,buflen-lastb)
C       append characters from the buffer to the output string
        if (nbyt .gt. 0)then
            if (nbuff .eq. 1)then
                array(in1:in1+nbyt-1)=buff1(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 2)then
                array(in1:in1+nbyt-1)=buff2(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 3)then
                array(in1:in1+nbyt-1)=buff3(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 4)then
                array(in1:in1+nbyt-1)=buff4(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 5)then
                array(in1:in1+nbyt-1)=buff5(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 6)then
                array(in1:in1+nbyt-1)=buff6(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 7)then
                array(in1:in1+nbyt-1)=buff7(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 8)then
                array(in1:in1+nbyt-1)=buff8(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 9)then
                array(in1:in1+nbyt-1)=buff9(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 10)then
                array(in1:in1+nbyt-1)=buff10(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 11)then
                array(in1:in1+nbyt-1)=buff11(lastb+1:lastb+nbyt)
            else if (nbuff .eq. 12)then
                array(in1:in1+nbyt-1)=buff12(lastb+1:lastb+nbyt)
            else
                status=102
                return
            end if

C           store the total number of bytes read:
            lastb=lastb+nbyt
            in1=in1+nbyt
            nleft=nleft-nbyt
        end if
        if (nleft .gt. 0)then
C               read in the next record, but first, check if the current
C               record has been modified.  If so, write it to disk.
                if (modify(nbuff))then
                 call ftpbyx(iunit,recnum(nbuff),buflen,nbuff,status)
                 if (status .gt. 0)return
                 modify(nbuff)=.false.
                end if

C               now read new record from disk
                recnum(nbuff)=recnum(nbuff)+1
                call ftgbyx(iunit,recnum(nbuff),buflen,nbuff,status)
                if (status .gt. 0)return

                lastb=0
C               go back for more bytes
                go to 10
        end if

C       convert the array of characters to ASCII, if required
        if (convrt .ne. 0)call ftas2c(array,nchar)

C       save the current position in the read buffer
        bytnum(nbuff)=lastb
        end
