C----------------------------------------------------------------------
        subroutine ftgbyx(iunit,recnum,nbytes,nbuff,status)

C       low-level routine to read bytes from a file

C       iunit   i  fortran unit number
C       recnum  i  direct access file record number
C       nbytes  i  number of bytes to read
C       nbuff   i  number of the buffer to read
C       status  i  output error status

        integer iunit,recnum,nbytes,nbuff,status,ios
        character*2880 buff1,buff2,buff3,buff4,buff5,buff6
        character*2880 buff7,buff8,buff9,buff10,buff11,buff12
        common/ft00b1/buff1
        common/ft00b2/buff2
        common/ft00b3/buff3
        common/ft00b4/buff4
        common/ft00b5/buff5
        common/ft00b6/buff6
        common/ft00b7/buff7
        common/ft00b8/buff8
        common/ft00b9/buff9
        common/ft0b10/buff10
        common/ft0b11/buff11
        common/ft0b12/buff12
        
        character*1 temp        
C       Note: we have to use separate buffers, rather than one big array
C       of buffers, because some compilers have a limit on the length of
C       a character array (e.g., 32K).

        if (status .gt. 0)return

C       read the record; if the read fails then initialize the buffer with zeros
        if (nbuff .eq. 1)then
                read(iunit,rec=recnum,iostat=ios)buff1(1:nbytes)
        else if (nbuff .eq. 2)then
                read(iunit,rec=recnum,iostat=ios)buff2(1:nbytes)
        else if (nbuff .eq. 3)then
                read(iunit,rec=recnum,iostat=ios)buff3(1:nbytes)
        else if (nbuff .eq. 4)then
                read(iunit,rec=recnum,iostat=ios)buff4(1:nbytes)
        else if (nbuff .eq. 5)then
                read(iunit,rec=recnum,iostat=ios)buff5(1:nbytes)
        else if (nbuff .eq. 6)then
                read(iunit,rec=recnum,iostat=ios)buff6(1:nbytes)
        else if (nbuff .eq. 7)then
                read(iunit,rec=recnum,iostat=ios)buff7(1:nbytes)
        else if (nbuff .eq. 8)then
                read(iunit,rec=recnum,iostat=ios)buff8(1:nbytes)
        else if (nbuff .eq. 9)then
                read(iunit,rec=recnum,iostat=ios)buff9(1:nbytes)
        else if (nbuff .eq. 10)then
                read(iunit,rec=recnum,iostat=ios)buff10(1:nbytes)
        else if (nbuff .eq. 11)then
                read(iunit,rec=recnum,iostat=ios)buff11(1:nbytes)
        else if (nbuff .eq. 12)then
                read(iunit,rec=recnum,iostat=ios)buff12(1:nbytes)
        else
                status=102
                return
        end if

C       if we failed to read the record, then just fill the
C       read buffer with all zeros
        if (ios .ne. 0)then
                call ftzero(nbuff,(nbytes+3)/4)
C               assume that this error indicates an end of file condition:
                status=107

C-------The following line was added 9/9/92 to work around an obscure
C       bug in the SUN fortran compiler.   SUN has issued 
C       FORTRAN patch number 100332 to fix the problem and it will also 
C       be fixed in the next FORTRAN release. The bug causes binary
C	unformated writes to another non-FITS file to write the wrong
C       number of bytes to the file.  The workaround is to attempt to
C       read a single byte from the FITS file.  

        read(iunit,rec=recnum,iostat=ios)temp
C-------end of bug fix code

        end if
        end
