C--------------------------------------------------------------------------
        subroutine ftgbtp(ibuff,keynam,value,status)

C       Get Binary Table Parameter
C       test if the keyword is one of the table column definition keywords
C       of a binary table. If so, decode it and update the values in the common
C       block

C       ibuff   i sequence number of the data buffer
C       OUTPUT PARAMETERS:
C       keynam  c name of the keyword
C       value   c value of the keyword
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ibuff,status,width
        character keynam*8,value*20

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
C       nb = number of file buffers = max. number of FITS file opened at once
C       nf = maximum number of fields allowed in a table
        integer nf,nb
        parameter (nb = 12)
        parameter (nf = 512)

C       tfield = number of fields in the table
C       tbcol = byte offset in the row of the beginning of the column
C       rowlen = length of one row of the table, in bytes
C       tdtype = integer code representing the datatype of the column
C       trept = the repeat count = number of data values/element in the column
C       tnull = the value used to represent an undefined value in the column
C       tscale = the scale factor for the column
C       tzero = the scaling zero point for the column
C       scount = the number of bytes of special data following the binary table
C       theap = the starting byte offset for the binary table heap, relative
C               to the start of the binary table data
C       nxheap = the next empty heap location

        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)

C-------END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer nfield
        character tform*8

        if (status .gt. 0)return

        if (keynam(1:5) .eq. 'TFORM')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TFORMn keyword
                    status=0
                else
C                   get the TFORM character string, without quotes
                    call ftc2s(value,tform,status)
C                   get the datatype code and repeat count
                    call ftbnfm(tform,tdtype(nfield,ibuff),
     &                 trept(nfield,ibuff),width,status)
C                   store the width of the ASCII field in the TNULL parameter
                    if (tdtype(nfield,ibuff) .eq. 16)then
                        tnull(nfield,ibuff)=width
                   end if
                end if
        else if (keynam(1:5) .eq. 'TSCAL')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TSCALn keyword
                    status=0
                else
C                   get the scale factor
                    call ftc2dd(value,tscale(nfield,ibuff),status)
                end if
        else if (keynam(1:5) .eq. 'TZERO')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TZEROn keyword
                    status=0
                else
C                   get the scaling zero point
                    call ftc2dd(value,tzero(nfield,ibuff),status)
                end if
        else if (keynam(1:5) .eq. 'TNULL')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TNULLn keyword
                    status=0
                else
C                   get the Null value flag (Integer)
                    call ftc2ii(value,tnull(nfield,ibuff),status)
                end if
        else if (keynam(1:8) .eq. 'THEAP   ')then
C               get the heap offset value
                call ftc2ii(value,theap(ibuff),status)
        end if
        end
