C--------------------------------------------------------------------------
        subroutine ftgbcl(iunit,colnum,xtype,xunit,dtype,rcount,
     &        xscal,xzero,xnull,xdisp,status)

C       Get information about a Binary table CoLumn
C       returns the parameters which define the column

C       iunit   i  Fortran i/o unit number
C       colnum  i  number of the column (first column = 1)
C       xtype   c  name of the column
C       xunit   c  physical units of the column
C       dtype   c  datatype of the column
C       rcount  i  repeat count of the column
C       xscal   d  scaling factor for the column values
C       xzero   d  scaling zero point for the column values
C       xnull   i  value used to represent undefined values in integer column
C       xdisp   c  display format for the column
C       status  i  returned error status

        integer iunit,colnum,rcount,xnull,status
        double precision xscal,xzero
        character*(*) xtype,xunit,dtype,xdisp

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
C       END OF COMMON BLOCK DEFINITIONS------------------------------------

        integer ibuff,nfound,tcode
        logical descrp
        character ctemp*2,fwide*4

        if (status .gt. 0)return

        ibuff=bufnum(iunit)

C       get the parameters which are stored in the common block
        rcount=trept(colnum,ibuff)
        xscal=tscale(colnum,ibuff)
        xzero=tzero(colnum,ibuff)
        xnull=tnull(colnum,ibuff)

C       translate the numeric data type code
        dtype=' '
        tcode=tdtype(colnum,ibuff) 
        if (tcode .lt. 0)then
                descrp=.true.
                tcode=-tcode
        else
                descrp=.false.
        end if

        if (tcode .eq. 21)then
                dtype='I'
        else if (tcode .eq. 41)then
                dtype='J'
        else if (tcode .eq. 42)then
                dtype='E'
        else if (tcode .eq. 82)then
                dtype='D'
        else if (tcode .eq. 16)then
C               this is an ASCII field; width of field is stored in TNULL
                write(fwide,1000)tnull(colnum,ibuff)
1000            format(i4)
                if (tnull(colnum,ibuff) .gt. 999)then
                    dtype='A'//fwide
                else if (tnull(colnum,ibuff) .gt. 99)then
                    dtype='A'//fwide(2:4)
                else if (tnull(colnum,ibuff) .gt. 9)then
                    dtype='A'//fwide(3:4)
                else if (tnull(colnum,ibuff) .gt. 0)then
                    dtype='A'//fwide(4:4)
                else
                    dtype='A'
                end if
        else if (tcode .eq. 14)then
                dtype='L'
        else if (tcode .eq. 1)then
                dtype='X'
        else if (tcode .eq. 11)then
                dtype='B'
        else if (tcode .eq. 83)then
                dtype='C'
        else if (tcode .eq. 163)then
                dtype='M'
        end if

        if (descrp)then
                ctemp='P'//dtype(1:1)
                dtype=ctemp
        end if

C       read remaining values from the header keywords
        xtype=' '
        call ftgkns(iunit,'TTYPE',colnum,1,xtype,nfound,status)
        xunit=' '
        call ftgkns(iunit,'TUNIT',colnum,1,xunit,nfound,status)
        xdisp=' '
        call ftgkns(iunit,'TDISP',colnum,1,xdisp,nfound,status)
        end        
