C--------------------------------------------------------------------------
        subroutine ftgatp(ibuff,keynam,value,status)

C       Get ASCII Table Parameter
C       test if the keyword is one of the table column definition keywords
C       of an ASCII table. If so, decode it and update the value in the common 
C       block

C       ibuff   i sequence number of the data buffer
C       OUTPUT PARAMETERS:
C       keynam  c name of the keyword
C       value   c value of the keyword
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ibuff,status
        character keynam*8,value*20

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
C       nb = number of file buffers = max. number of FITS file opened at once
C       nf = maximum number of fields allowed in a table
        integer nf,nb
        parameter (nb = 12)
        parameter (nf = 512)

C       tfield = number of fields in the table
C       tbcol = byte offset in the row of the beginning of the column
C       rowlen = length of one row of the table, in bytes
C       tdtype = integer code representing the datatype of the column
C       trept = the repeat count = number of data values/element in the column
C       tnull = the value used to represent an undefined value in the column
C       tscale = the scale factor for the column
C       tzero = the scaling zero point for the column
C       scount = the number of bytes of special data following the binary table
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)

C       cnull = character string representing nulls in character columns
C       cform = the Fortran format of the column
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
C-------END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer nfield,i,c2,bcol
        character tform*8

        if (status .gt. 0)return

        if (keynam(1:5) .eq. 'TFORM')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TFORMn keyword
                    status=0
                else
C                   get the TFORM character string, without quotes
                    call ftc2s(value,tform,status)
                    if (status .gt. 0)return
                    cform(nfield,ibuff)=tform
C                   set numeric data type code to indicate an ASCII table field
                    tdtype(nfield,ibuff)=16
C                   set the repeat count to 1
                    trept(nfield,ibuff)=1
C                   set the TNULL parameter to the width of the field:
                    c2=0
                    do 10 i=2,8
                        if (tform(i:i) .ge. '0' .and. tform(i:i)
     &                     .le. '9')then
                                c2=i
                        else
                                go to 20
                        end if
10                  continue
20                  continue

                    if (status .gt. 0)return
                    if (c2 .eq. 0)then
C                       no explicit field width, so assume width=1 character
                        tnull(nfield,ibuff)=1
                    else
                        call ftc2ii(tform(2:c2),tnull(nfield,ibuff),
     &                              status)
                        if (status .gt. 0)then
C                               error parsing the TFORM value string
                                status=261
                        end if
                    end if
                end if
        else if (keynam(1:5) .eq. 'TBCOL')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TBCOLn keyword
                    status=0
                else
C                   get the beginning column number
                    call ftc2ii(value,bcol,status)
                    tbcol(nfield,ibuff)=bcol-1
                end if
        else if (keynam(1:5) .eq. 'TSCAL')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TSCALn keyword
                    status=0
                else
C                   get the scale factor
                    call ftc2dd(value,tscale(nfield,ibuff),status)
                end if
        else if (keynam(1:5) .eq. 'TZERO')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TZEROn keyword
                    status=0
                else
C                   get the scaling zero point
                    call ftc2dd(value,tzero(nfield,ibuff),status)
                end if
        else if (keynam(1:5) .eq. 'TNULL')then
C               get the field number
                call ftc2ii(keynam(6:8),nfield,status)
                if (keynam(6:8) .eq. '   ' .or. status .gt. 0)then
C                   this must not have been a TFORMn keyword
                    status=0
                else
C                   get the Null value flag (character)
                    call ftc2s(value,cnull(nfield,ibuff),status)
                end if
        end if
        end
