C--------------------------------------------------------------------------
        subroutine ftclos(iunit,status)

C       close a FITS file that was previously opened with ftopen or ftinit
C
C       iunit   i  Fortran I/O unit number
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,status

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS---------------------------------------

        integer ibuff

        ibuff=bufnum(iunit)

C       close the current HDU and pad the header with blanks
        call ftchdu(iunit,status)

C       if there is an error, don't try to move to the end of the file
        if (status .le. 0)then
C         move to the end of file (to insure that all the records are saved)
          call ftmbyt(iunit,hdstrt(ibuff,maxhdu(ibuff)+1),.true.,status)
        end if

C       close the file
        call ftclsx(iunit,status)
        end
