C--------------------------------------------------------------------------
        subroutine ftbfil(iunit,status)

C       initialize the ASCII table by filling it with blanks

C       iunit   i  Fortan i/o unit number
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, February 1991

        integer iunit,status

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        character rec*2880, xdummy*2880
        common/ftheap/rec,xdummy
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer ibuff,nrec,i

        if (status .gt. 0)return

        ibuff=bufnum(iunit)
        rec=' '

C       calculate the number of 2880-byte records needed to fill the data unit
C       (the data buffer is by definition an exact multiple of 2880 bytes long)
        nrec=(hdstrt(ibuff,chdu(ibuff)+1)-dtstrt(ibuff))/2880

C       move to the beginning of the data area
        call ftmbyt(iunit,dtstrt(ibuff),.true.,status)

        do 10 i=1,nrec
C               write 2880 blanks at a time to the output buffer:
                call ftpcbf(iunit,1,2880,rec,status)
10      continue
        end
