C--------------------------------------------------------------------------
        subroutine ftaini(iunit,status)

C       initialize the parameters defining the structure of an ASCII table 

C       iunit   i  Fortran I/O unit number
C       OUTPUT PARAMETERS:
C       status  i  returned error status (0=ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer iunit,status

C-------COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nf,nb,ne
        parameter (nb = 12)
        parameter (nf = 512)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
C-------END OF COMMON BLOCK DEFINITIONS-----------------------------------

        integer nrows,tfld,nkey,ibuff,i,nblank
        character keynam*8,value*20,comm*8

        if (status .gt. 0)return

C       define the number of the buffer used for this file
        ibuff=bufnum(iunit)

C       temporarily set the location of the end of the header to a huge number
        hdend(ibuff)=1000000000
        hdstrt(ibuff,chdu(ibuff)+1)=100000000

C       check that this is a valid ASCII table, and get parameters
        call ftgttb(iunit,rowlen(ibuff),nrows,tfld,status)
        if (status .gt. 0)go to 900

        if (tfld .gt. nf)then
C               arrays not dimensioned large enough for this many fields
                status=111
                go to 900
         end if

C       store the number of fields in the common block
        tfield(ibuff)=tfld

C       initialize the table field parameters
        do 5 i=1,tfld
                tscale(i,ibuff)=1.
                tzero(i,ibuff)=0.
C               choose special value to indicate that null value is not defined
                cnull(i,ibuff)=char(1)
5       continue

C       now read through the rest of the header looking for table column
C       definition keywords, and the END keyword.

        nkey=8
8       nblank=0
10      nkey=nkey+1
        call ftgkyn(iunit,nkey,keynam,value,comm,status)
        if (status .gt. 0)go to 900
        if (keynam(1:1) .eq. 'T')then
C               get the ASCII table parameter (if it is one)
                call ftgatp(ibuff,keynam,value,status)
        else if (keynam .eq. ' ' .and. comm .eq. ' ')then
                nblank=nblank+1
                go to 10
        else if (keynam .eq. 'END')then
                go to 20
        end if
        go to 8

20      continue

C       now we know everything about the table; just fill in the parameters:
C       the 'END' record begins 80 bytes before the current position,
C       ignoring any trailing blank keywords just before the END keyword
        hdend(ibuff)=nxthdr(ibuff)-80*(nblank+1)

C       the data unit begins at the beginning of the next logical block
        dtstrt(ibuff)=((nxthdr(ibuff)-80)/2880+1)*2880

C       reset header pointer to the first keyword
        nxthdr(ibuff)=hdstrt(ibuff,chdu(ibuff))

C       there is no special data following an ASCII table
        scount(ibuff)=0

C       the next HDU begins in the next logical block after the data
        hdstrt(ibuff,chdu(ibuff)+1)=
     &  dtstrt(ibuff)+(rowlen(ibuff)*nrows+2879)/2880*2880

900     continue
        end
