C--------------------------------------------------------------------------
        subroutine ftadef(ounit,lenrow,nfield,bcol,tform,nrows,status)

C       Ascii table data DEFinition
C       define the structure of the ASCII table data unit
C
C       ounit   i  Fortran I/O unit number
C       lenrow  i  length of a row, in characters
C       nfield  i  number of fields in the table
C       bcol    i  starting position of each column, (starting with 1)
C       tform   C  the data format of the column
C       nrows   i  number of rows in the table
C       status  i  output error status (0 = ok)
C
C       written by Wm Pence, HEASARC/GSFC, June 1991

        integer ounit,lenrow,nfield,bcol(*),nrows,status
        character*(*) tform(*)

C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne,nf
        parameter (nb = 12)
        parameter (ne = 128)
        parameter (nf = 512)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,maxhdu,hdstrt,hdend,nxthdr,dtstrt
        logical wrmode,modify
        real compid
        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
        integer tfield,tbcol,rowlen,tdtype,trept,tnull,scount
        integer theap,nxheap
        double precision tscale,tzero
        common/ft0002/tfield(nb),tbcol(nf,nb),rowlen(nb),tdtype(nf,nb),
     &  trept(nf,nb),tscale(nf,nb),tzero(nf,nb),tnull(nf,nb),scount(nb)
     &  ,theap(nb),nxheap(nb)
        character*8 cnull,cform
        common/ft0003/cnull(nf,nb),cform(nf,nb)
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------
        
        integer ibuff,i,j,clen,c2

        if (status .gt. 0)return

        ibuff=bufnum(ounit)

        if (dtstrt(ibuff) .lt. 0)then
C               freeze the header at its current size
                call fthdef(ounit,0,status)
                if (status .gt. 0)return
        end if

        tfield(ibuff)=nfield
        if (nfield .eq. 0)then
C           no data; the next HDU begins in the next logical block 
            hdstrt(ibuff,chdu(ibuff)+1)=dtstrt(ibuff)
        else
C           initialize the table column parameters
            clen=len(tform(1))
            do 20 i=1,nfield
                tscale(i,ibuff)=1.
                tzero(i,ibuff)=0.
C               choose special value to indicate null values are not defined
                cnull(i,ibuff)=char(1)
                cform(i,ibuff)=tform(i)
                tbcol(i,ibuff)=bcol(i)-1
                tdtype(i,ibuff)=16
C               the repeat count is always one for ASCII tables
                trept(i,ibuff)=1
C               store the width of the field in TNULL
                c2=0
                do 10 j=2,clen
                        if (tform(i)(j:j) .ge. '0' .and.
     &                     tform(i)(j:j) .le. '9')then
                                c2=j
                        else
                                go to 15
                        end if
10              continue
15              continue
                if (c2 .eq. 0)then
C                       no explicit width, so assume width of 1 character
                        tnull(i,ibuff)=1
                else
                    call ftc2ii(tform(i)(2:c2),tnull(i,ibuff),status)
                    if (status .gt. 0)then
C                               error parsing TFORM to determine field width
                                status=261
                                return
                    end if
                end if
20           continue

C           ASCII tables have no special data area
            scount(ibuff)=0

C           calculate the start of the next header unit, based on the
C           size of the data unit
            rowlen(ibuff)=lenrow
            hdstrt(ibuff,chdu(ibuff)+1)=
     &          dtstrt(ibuff)+(lenrow*nrows+2879)/2880*2880

C           have to initialize the ASCII table by filling it with blanks
            call ftbfil(ounit,status)
        end if
        end
