        program rsimpl

C       A simple program to read the FITS primary array and a binary table 
C       extension that was created by the WSIMPLE program.
C       This is designed to illustrate the basic sequence of FITSIO calls
C       needed to read a FITS file.

        integer iunit,status,bitpix,naxis,naxes(99),pcount,gcount
        integer group,fpixel,nelem,i,j,jvals(3),rwstat,bksize
        integer ivalue(20),colnum,frow,felem
        integer hdutyp,inull
        real evals(3),enull
        logical simple,extend,anyflg
        character*30 errtxt

        status=0
        iunit=15
C       open the existing FITS file with readonly access
        rwstat=0
        call ftopen(iunit,'simple.fit',rwstat,bksize,status)

C       read the required primary array keywords
        call ftghpr(iunit,99,simple,bitpix,naxis,naxes,pcount,gcount,
     &       extend,status)
        if (status .ne. 0)go to 99

C       read the 2D array, one row at at time
C       (Note that one could read the entire array with one subroutine
C        call if preferred).

C       first, test to make sure this is a 2D array
        if (naxis .ne. 2)then
            print *,'This program only works on a 2D FITS array'
            go to 100
        end if

C       read and print each row of the table
        group=0
        fpixel=1
        do 10 i=1,naxes(2)
            call ftgpvj(iunit,group,fpixel,naxes(1),0,ivalue,
     &                  anyflg,status)
            print *,'Row ',i
            print *,(ivalue(j),j=1,naxes(1))
            fpixel=fpixel+naxes(1)
10      continue

C       now move to the binary table extension
        call ftmahd(iunit,2,hdutyp,status)

C       assume that we already know that the table has 3 rows and 2 columns
C           the first column is integer, the second is real*4

C       read the integers from the 1st column
        colnum=1
        frow=1
        felem=1
        nelem=3
        inull=0
        call ftgcvj(iunit,colnum,frow,felem,nelem,inull,jvals,anyflg,
     1              status)

	print *,'column 1:'
        print *,(jvals(i),i=1,nelem)

C       read the reals from the 1st column
        colnum=2
        frow=1
        felem=1
        nelem=3
        enull=0.
        call ftgcve(iunit,colnum,frow,felem,nelem,enull,evals,anyflg,
     1              status)

	print *,'column 2:'
        print *,(evals(i),i=1,nelem)

C       now close the table and quit
        call ftclos(iunit,status)

99      if (status .le. 0)then
                print *,'*** Program completed successfully ***'
        else
C          get the error text description
           call ftgerr(status,errtxt)
           print *,'*** ERROR - program did not run successfully ***'
           print *,'status =',status,': ',errtxt
        end if

100     continue
        end
