        program makepc

C---------------------------------------------------------------------------
C       Program to build an object library of the FITSIO subroutines on
C       an IBM compatible PC using Microsoft Fortran V5.0.   It should be
C       easy to modify for any other microcomputer/compiler combination.
C
C       The FITSIO subroutines come in 2 files: fitsio.for and fitspc.for.
C       If one just compiles these 2 files and builds an object library,
C       then usually all the subroutines get linked into the executable,
C       regardless of whether or not they are actually called by the program.
C       The solution to this is to separate each subroutine into an individual
C       file and then compile each file separately.  The library is then
C       built from all the separate object files.    Then only the subroutines
C       that are actually used will be linked into the executable.  This 
C       can reduce the size of the excutable by up to 50%.
C
C       This program splits each subroutine into a separate file, and creates
C       a MAKEFITS.BAT batch file which can then be run to compile each
C       file and insert the object files into the FITSIO.LIB library.
C
C       To build the FITSIO library, follow these steps:
C
C            1.  Put the FITSIO.FOR, FITSPC.FOR and MAKEPC.FOR files in
C                a new subdirectory.    About 1 MByte of free diskspace
C                will be required.
C
C            2.  Edit MAKEPC.FOR, if necessary, so that it writes the
C                correct Fortran compiler and LIB statements into the
C                output MAKEFITS.BAT file (the path or compile option
C                switches may need to be modified for each system).
C
C            3.  Compile, Link, and Run MAKEPC to split each subroutine
C                into a separate file and create MAKEFITS.BAT.
C
C            4.  Run the batch file called MAKEFITS.BAT to create the
C                FITSIO.LIB object library.
C
C            5.  Put the FITSIO.LIB library in a suitable subdirectory for
C                use when linking with any program which calls the FITSIO
C                subroutines.
C---------------------------------------------------------------------------

C       written by William Pence, HEASARC
C       2 April 1992

        character line*80,infile*12,fout*3
        integer nout,i,j

C       open the output for the batch file which will compile and build the lib
        open(unit=12,file='makefits.bat',status='NEW')
C       this first statement in the batch file creates the new library:
        write(12,1000)'lib fitsio;'

        nout=1
C       start by  processing the 'fitspc.for' source file
        infile='fitspc.for'

10      open(unit=10,file=infile,status='OLD')

C       create unique name and open the output source file for each subroutine
20      write(fout,1001)nout
1001    format(i3)
        if (fout(1:1) .eq. ' ')fout(1:1)='0'
        if (fout(2:2) .eq. ' ')fout(2:2)='0'
        open(unit=11,file='ftsub'//fout//'.for',status='NEW')

C       read one line from the input file, and write to the output file
30      read(10,1000,end=100)line
1000    format(a)

C       find end of line (we don't want to write a lot of unnecessary blanks)
        j=80
        do 40 i=80,2,-1
                if (line(i:i) .ne. ' ')go to 50
                j=j-1
40      continue

C       write out the line
50      write(11,1000)line(1:j)

C       test for end of subroutine
        if (line .eq. '        end')then
                close(unit=11)
                nout=nout+1

C**************************************************************************
C       The following lines may need to be change for each individual system
C        to envoke the fortran compiler with all the desired options:
C**************************************************************************
                write(12,1000)
     &    'c:\fort\bin\fl.exe /FPi /Gt /G2 /c ftsub'//fout//'.for'


C**************************************************************************
C       The following line may need to be change for each individual system
C        to envoke the LIBrary utility with any desired options:
C**************************************************************************
                write(12,1000)'lib fitsio +ftsub'//fout//';'

                go to 20
        end if                
        go to 30

100     continue
        if (infile .eq. 'fitspc.for')then
C               finished the first source file, now go back and do 'FITSIO.FOR'
                infile='fitsio.for'
                close(unit=10)
                go to 10
        end if

C       all done, 
        close(unit=12)
        end
